
## 1. 使用指南

### 1.1 通用连接与请求格式

所有数据同步操作都使用Unix Socket通信，以下是基本连接流程：


- 在目标库创建同步状态表

 ```sql
CREATE TABLE `kunlun_cdc_dump_state` (
  `job_id` varchar(64) not NULL,
  `repl_info` varchar(1024) default '',
  `commit_sql_num` int default 0,
  PRIMARY KEY(`job_id`)
);
 ```
 - 在目标库创建同步表

```sql

 CREATE TABLE IF NOT EXISTS c1 (__sys_obj_id__ VARCHAR PRIMARY KEY,doc LONGTEXT,optype enum('insert','update','delete') DEFAULT 'insert');

```


### 1.2 创建同步任务

#### 1.2.1 Elasticsearch同步任务

```json
{
  "job_id": "es_sync_job_1",          // 任务ID，必填
  "url": "http://elasticsearch:9200", // ES URL，必填
  "db_user": "elastic",               // ES用户名，可选
  "db_passwd": "password",            // ES密码，可选
  "db_database": "my_index",          // ES索引名，必填
  "db_table": "_doc",                 // 文档类型，通常为"_doc"，必填
  "dump_db_type": "es",               // 数据库类型，使用"es"而非"elasticsearch"，必填
  "gtid": "doc_id_12345",             // 文档ID作为GTID起始点，必填
  "event_type": "create",             // 事件类型，必填
}
```

#### 1.2.2 MongoDB同步任务

```json
{
  "job_id": "mongo_sync_job_1",       // 任务ID，必填
  "url": "mongodb://localhost:27017", // MongoDB连接URI，必填
  "db_user": "admin",                 // MongoDB用户名，必填
  "db_passwd": "password",            // MongoDB密码，必填
  "db_database": "my_database",       // 数据库名，必填
  "db_table": "my_collection",        // 集合名，必填
  "dump_db_type": "mongodb",          // 数据库类型，必填
  "gtid": "507f1f77bcf86cd799439011", // ObjectID作为GTID，必填
  "event_type": "create",             // 事件类型，必填
}
```

### 1.3 获取任务状态

```json
{
  "job_id": "es_sync_job_1",     // 任务ID，必填
  "event_type": "status",        // 事件类型，必填为"status"
  "dump_db_type": "es",          // 与创建任务时使用相同的数据库类型
  "use_stream_mode": true        // 如果是流模式任务则设为true
}
```

### 1.4 任务管理命令

#### 1.4.1 停止任务

```json
{
  "job_id": "es_sync_job_1",      // 任务ID，必填
  "event_type": "stop",           // 事件类型，必填为"stop"
  "dump_db_type": "es",           // 与创建任务时使用相同的数据库类型
  "use_stream_mode": true         // 如果是流模式任务则设为true
}
```

#### 1.4.2 删除任务

```json
{
  "job_id": "es_sync_job_1",      // 任务ID，必填
  "event_type": "remove",         // 事件类型，必填为"remove"
  "dump_db_type": "es",           // 与创建任务时使用相同的数据库类型
  "use_stream_mode": true         // 如果是流模式任务则设为true
}
```


### 1.6 数据传输格式

数据传输采用二进制格式，以下是格式说明：

1. **消息类型** (1字节): 用于标识消息类型，例如`MReqrowmsg`(13)
2. **行数量** (4字节): 当前批次的总行数
3. **GTID** (长度+字符串): 数据源的标识符(ES文档ID、MongoDB ObjectID等)
4. **版本号** (4字节): 用于标识数据版本，ES中为0
5. **数据类型** (1字节): 操作类型(13=插入, 14=更新, 15=删除)
6. **数据库名** (长度+字符串): 数据库或索引名称
7. **表/集合名** (长度+字符串): 表、集合或文档类型名称
8. **GTID重复** (长度+字符串): 再次写入GTID(兼容性设计)
9. **查询参数** (4字节): ES和MongoDB中通常为0
10. **字段数量** (4字节): 数据中的字段数
11. **字段名数组**: 每个字段的名称(长度+字符串)
12. **字段属性数组**: 每个字段的属性(4字节整数，通常为0)
13. **文档数量** (4字节): 实际发送的文档数
14. **文档数据**: 每行数据的每个字段值(长度+字符串)

### 1.7 GTID获取方法

#### 1.7.1 Elasticsearch GTID获取

对于Elasticsearch，GTID通常是文档ID，可以通过以下方式获取：

```bash
# 获取索引中按ID排序的第一条记录
curl -X GET "http://your-es-host:9200/your-index/_search?size=1&sort=_id:asc"
```

从结果中提取`_id`字段值作为初始GTID。

#### 1.7.2 MongoDB GTID获取

对于MongoDB，GTID通常是ObjectID，可以通过以下方式获取：

```javascript
// 在MongoDB shell中执行
db.your_collection.find().sort({_id: 1}).limit(1).pretty()
```

从结果中提取`_id`字段值作为初始GTID。


## 2. GTID断点续传机制

### 2.1 GTID概念

GTID（Global Transaction ID，全局事务标识符）是确保数据同步一致性的关键机制。在本系统中，GTID作为断点记忆的核心标识，用于：

1. **定位同步位置**：精确标识事务在源数据库中的位置
2. **避免重复同步**：确保每个事务只被处理一次
3. **保证顺序性**：维持事务的先后顺序
4. **支持故障恢复**：在系统崩溃后从正确位置恢复

### 2.2 GTID格式

不同数据库系统的GTID格式有所不同：
- **MongoDB**：时间戳格式的ObjectId，例如 `507f1f77bcf86cd799439011`
- **Elasticsearch**：自定义格式，如 `index-name:sequence-number`，或直接使用文档ID

### 2.3 GTID处理流程

1. **初始化**：同步任务必须提供初始GTID
2. **跟踪**：系统持续跟踪并更新当前处理的GTID
3. **存储**：定期将最新GTID保存到检查点
4. **恢复**：任务重启时从保存的GTID位置继续处理
5. **验证**：确保GTID值的合法性和有效性

### 2.4 断点续传实现

1. **创建任务时**：必须提供有效的GTID值
2. **处理数据时**：持续更新最新处理的GTID
3. **保存检查点时**：将GTID与其他元数据一起保存
4. **恢复任务时**：优先使用检查点中的GTID
5. **查询状态时**：返回当前处理的GTID信息


## 两种数据源同步流转函数细化

## 3.1.1 Elasticsearch数据同步流转与函数映射

```
+------------------+                  +---------------------+                 +------------------+
|                  |                  |                     |                 |                  |
|  Elasticsearch   |                  |   consistent_sql    |                 |   目标存储        |
|                  |                  |                     |                 |                  |
+--------+---------+                  +----------+----------+                 +--------+---------+
         |                                       |                                     |
         |                                       |                                     |
         |  1. 初始化请求                        |                                     |
         +-------------------------------------->+                                     |
         |                                       |  StartTaskES()                      |
         |  2. ES API调用                        |                                     |
         +<--------------------------------------+                                     |
         |                                       |                                     |
         |                                       |  3. syncESTask()                    |
         |                                       | +-----------------------+           |
         |                                       | | • 构建批处理参数       |           |
         |                                       | | • 构建滚动API查询     |           |
         |                                       | | • 记录LastScrollID   |           |           
         |                                       | +-----------------------+           |
         |                                       |                                     |
         |                                       |  4. sendSyncResult()                |
         |                                       +------------------------------------>+
         |                                       |                                     |
         |                                       |  5. 接收确认                        |
         |                                       +<------------------------------------+
         |                                       |                                     |
         |                                       |  6. updateTaskStatus()              |
         |                                       |                                     |
         |                     +----------------+|                                     |
         |                     |                ||                                     |
         |                     | ESTaskStatus   |<+                                     |
         |                     | LastScrollID   ||                                     |
         |                     |                |+                                     |
         |                     +----------------+                                      |
         |                                       |                                     |
```

## 3.2.2 MongoDB数据同步流转与函数映射

```
+------------------+                  +---------------------+                 +------------------+
|                  |                  |                     |                 |                  |
|    MongoDB       |                  |   consistent_sql    |                 |   目标存储        |
|                  |                  |                     |                 |                  |
+--------+---------+                  +----------+----------+                 +--------+---------+
         |                                       |                                     |
         |                                       |                                     |
         |  1. 连接初始化                        |                                     |
         +-------------------------------------->+                                     |
         |                                       |  StartTaskMongo()                   |
         |  2. 数据获取                          |                                     |
         +<--------------------------------------+                                     |
         |                                       |                                     |
         |                                       |  3. syncMongoTask()                 |
         |                                       | +------------------------+          |
         |                                       | | • 连接MongoDB         |          |
         |                                       | | • SyncMongoTask()     |          |
         |                                       | | • 跟踪ObjectId作为GTID |          |
         |                                       | +------------------------+          |
         |                                       |                                     |
         |                                       |  4. sendSyncResult()                |
         |                                       +------------------------------------>+
         |                                       |                                     |
         |                                       |  5. 响应接收                        |
         |                                       +<------------------------------------+
         |                                       |                                     |
         |                                       |  6. updateTaskStatus()              |
         |                                       |                                     |
         |                    +-----------------+|                                     |
         |                    |                 ||                                     |
         |                    | MongoTaskStatus |<+                                    |
         |                    | LastID (GTID)   ||                                    |
         |                    |                 |+                                     |
         |                    +-----------------+                                      |
         |                                       |                                     |
```
## 3.4 函数说明与工作流程

### 3.4.1 Elasticsearch同步函数工作流程

1. `StartTaskES()`: 初始化ES同步任务，创建任务状态并启动工作协程
   - 设置FirstSend=true标记首次发送
   - 设置WaitingAck=false初始化等待确认状态
   - 创建context和取消函数进行任务管理
   
2. `syncESTask()`: 执行ES同步任务的主要流程
   - 获取或创建ES HTTP客户端
   - 构建批处理参数和滚动API查询
   - 迭代处理ES数据
   - 注册确认消息处理回调函数
   - **增量同步机制**：同步到最后一条数据后不退出，持续监听新数据
   - **消息确认机制**：
     - 首次发送数据(FirstSend=true)不等待确认，继续处理
     - 后续发送后(FirstSend=false)将WaitingAck设为true，等待确认
     - 收到确认后(MRsprowmsg)将WaitingAck设为false，继续处理
   - **断点记忆**：使用LastScrollID和LastTimestamp作为断点

3. `getESClient()`: 获取或创建优化过的ES HTTP客户端
   - 维护连接池，重用HTTP客户端
   - 优化连接参数，提高性能

4. `sendSyncResult()`: 将处理后的数据发送到目标系统
   - **消息格式**：采用与MongoDB相同的二进制协议格式
     - 消息类型(MReqrowmsg)：标识消息类型
     - 行数(uint32)：当前批次的总行数
     - GTID(长度+字符串)：ES文档ID作为GTID
     - binlog_file(int32)：ES无binlog，置为0
     - 数据类型(int8)：默认使用insert=13
     - 数据库名(长度+字符串)："elasticsearch"
     - 索引名(长度+字符串)：ES索引名
     - GTID再次写入(长度+字符串)：重复写入GTID
     - SQL(int32)：ES无SQL，置为0
     - 列数量(uint32)：根据实际字段数确定
     - 列名数组：每列的名称(长度+字符串)
     - 列属性数组：每列的属性(uint32，均为0)
     - 行数(uint32)：每次发送批量数据
     - 行内容：包含每列的值(长度+字符串)
   - **错误重试**：引入重试机制，失败后自动重试

5. `updateTaskStatusFull()`: 更新任务状态，包括LastScrollID、LastTimestamp、FirstSend和WaitingAck状态
   - 全面记录任务状态，支持断点续传和消息确认机制

6. `ESTaskStatus`: 包含IsRunning、LastScrollID、LastTimestamp、FirstSend和WaitingAck等任务状态信息
   - FirstSend：标记是否是首次发送数据
   - WaitingAck：标记是否正在等待确认

7. `registerAckHandler()` 和 `HandleAckMessage()`：
   - 注册和处理确认消息的回调函数
   - 支持不同消息类型的处理
   - 确保异步消息处理的线程安全

### 3.4.2 MongoDB同步函数工作流程

1. `StartTaskMongo()`: 初始化MongoDB同步任务，创建任务状态并启动工作协程
   - 设置FirstSend=true标记首次发送
   - 设置WaitingAck=false初始化等待确认状态
   - 创建context和取消函数进行任务管理

2. `syncMongoTask()`: 处理MongoDB同步任务的主要流程
   - 连接MongoDB数据库
   - 基于GTID查询数据
   - 迭代处理数据变更
   - 注册确认消息处理回调函数
   - **增量同步机制**：同步到最后一条数据后不退出，持续监听新数据
   - **消息确认机制**：
     - 首次发送数据(FirstSend=true)不等待确认，继续处理
     - 后续发送后(FirstSend=false)将WaitingAck设为true，等待确认
     - 收到确认后(MRsprowmsg)将WaitingAck设为false，继续处理
   - **断点记忆**：使用LastID(ObjectID)作为断点

3. `SyncMongoTask()`: 实际查询并同步MongoDB数据的函数
   - 构建ObjectID过滤查询(_id > lastID)
   - 设置批处理大小和排序
   - 返回文档批次和最后ObjectID

4. `sendSyncResult()`: 将处理后的数据发送到目标系统
   - **数据格式**：二进制消息包含以下字段
     - 消息类型(MReqrowmsg)：标识消息类型
     - 行数(uint32)：当前批次的总行数
     - GTID(长度+字符串)：MongoDB的ObjectId作为GTID
     - binlog_file(int32)：MongoDB无binlog，置为0
     - 数据类型(int8)：插入=13/更新=14/删除=15
     - 数据库名(长度+字符串)：MongoDB数据库名
     - 表名(长度+字符串)：MongoDB集合名
     - GTID再次写入(长度+字符串)：重复写入GTID
     - SQL(int32)：MongoDB无SQL，置为0
     - 列数量(uint32)：MongoDB使用3列(_id, data, optype)
     - 列名数组：每列的名称(长度+字符串)
     - 列属性数组：每列的属性(uint32，均为0)
     - 行数(uint32)：批量发送行数
     - 行内容：包含每列的值(长度+字符串)
     - 更新操作额外字段：旧值信息(更新操作时)
   - **错误重试**：引入重试机制，失败后自动重试
     
   - **消息发送逻辑**：
     - 第一次发送数据时(FirstSend=true)，不等待确认就继续处理
     - 后续发送数据后(FirstSend=false)，标记为等待确认状态(WaitingAck=true)
     - 收到确认消息后，才可以继续发送下一批数据

   - **消息接收逻辑**：
     - 使用回调函数注册机制接收和处理确认消息
     - 使用正确的二进制协议格式读取消息长度和内容
     - 当接收到MRsprowmsg消息时，通知主循环继续处理

5. `updateTaskStatus()`: 更新任务状态，包括LastID(GTID)、FirstSend和WaitingAck信息
   - 全面记录任务状态，支持断点续传和消息确认机制

6. `MongoTaskStatus`: 包含IsRunning、LastID、Error、FirstSend和WaitingAck等任务状态信息
   - FirstSend：标记是否是首次发送数据
   - WaitingAck：标记是否正在等待确认

7. `registerAckHandler()` 和 `HandleAckMessage()`：
   - 注册和处理确认消息的回调函数
   - 支持不同消息类型的处理
   - 确保异步消息处理的线程安全

### 3.4.3 数据源同步的一致性处理机制

1. **消息确认机制统一**：
   - MongoDB和Elasticsearch使用相同的消息确认机制
   - 首次发送时不等待确认，后续发送必须等待确认
   - 确保数据按顺序被处理，避免数据丢失

2. **数据格式统一**：
   - 两种数据源发送的消息格式完全一致
   - 使用相同的消息类型和字段结构
   - 便于客户端使用统一方式处理不同来源的数据

3. **持续增量同步**：
   - 同步到最后一条数据后不退出，持续监听新数据
   - 使用适当的等待间隔，避免频繁空查询
   - 当无新数据时，MongoDB清理资源并等待
   - 当无新数据时，Elasticsearch清理scroll并等待
   - 保证任务持续运行，捕获所有数据变更

4. **断点续传一致性**：
   - MongoDB使用ObjectID作为GTID
   - Elasticsearch使用ScrollID和LastTimestamp作为断点
   - 两者都支持任务重启后从断点继续
   - 确保不会遗漏或重复处理数据
